<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::unprepared('
            CREATE TRIGGER tr_user_courses_before_insert
            BEFORE INSERT ON User_courses
            FOR EACH ROW
            BEGIN
                IF NEW.Payment_id IS NOT NULL AND (SELECT Payment_status FROM Payments WHERE Payment_id = NEW.Payment_id) != \'completed\' THEN
                    SIGNAL SQLSTATE \'45000\'
                    SET MESSAGE_TEXT = \'Payment must be completed before enrollment.\';
                END IF;
            END;
        ');
    }

    public function down(): void
    {
        DB::unprepared('DROP TRIGGER IF EXISTS tr_user_courses_before_insert');
    }
};
